unit uVerkn;

interface

Function SpecialDirectory(ID:integer):string;
Function CreateFolder(Foldername:string):boolean;
Function CreateLink(Aufruf, Parameter, Lnk_Datei, Beschreibung: string):Boolean;

Function Autostartverzeichnis: String;
Function DesktopVerzeichnis: String;
Function StartmenueVerzeichnis: String;

implementation

{$IFDEF VER90}
uses OLE2, ComCtrls, ShlObj, SysUtils, Windows;
{$ELSE}
uses ActiveX, ComObj, ShlObj, SysUtils, Windows;
{$ENDIF}

const
  IID_IPersistFile : TGUID =
    (D1:$0000010B;D2:$0000;D3:$0000;D4:($C0,$00,$00,$00,$00,$00,$00,$46));
  IID_IShellLinkA: TGUID = 
    (D1:$000214EE; D2:$0000; D3:$0000; D4:($C0,$00,$00,$00,$00,$00,$00,$46));
  max_path = 1024;

Function Autostartverzeichnis: String;
begin
   Result := SpecialDirectory(CSIDL_Startup)
end;

Function DesktopVerzeichnis: String;
begin
   Result := SpecialDirectory(CSIDL_Desktopdirectory)
end;

Function StartmenueVerzeichnis: String;
begin
   Result := SpecialDirectory(CSIDL_Programs)
end;

function SpecialDirectory(ID:integer):string;
var pidl : PItemIDList;
    Path : PChar;
begin
  if SUCCEEDED(SHGetSpecialFolderLocation(0,ID,pidl)) then begin
    Path:=StrAlloc(max_path);
    SHGetPathFromIDList(pidl,Path);
    Result:=String(Path);
    if Result[length(Result)]<>'\' then
      Result:=Result+'\';
  end;
end; {SpecialDirectory}

Function CreateFolder(Foldername:string):boolean;
begin
  Result:=false;
  SetLastError(0);
  CreateDirectory(PChar(Foldername), nil );
  if (GetLastError()=0) or (GetLastError()=ERROR_ALREADY_EXISTS) then
    Result:=true;
end; {CreateFolder}


Function CreateLink(Aufruf, Parameter, Lnk_Datei, Beschreibung: string):Boolean;
var psl : IShellLink;
    ppf : IPersistFile;
begin
  Result:=false;
  if SUCCEEDED(CoCreateInstance(CLSID_ShellLink,nil,CLSCTX_INPROC_SERVER, IID_IShellLinkA, psl)) then begin
    psl.SetPath(PChar(Aufruf));
    psl.SetDescription(PChar(Beschreibung));
    psl.SetWorkingDirectory (PChar(ExtractFileDir(Aufruf)));
    psl.SetArguments (PChar(Parameter));
    if SUCCEEDED(psl.QueryInterface(IID_IPersistFile,ppf)) then begin
      ppf.Save(StringToOLEStr(Lnk_Datei),TRUE);
      Result:=true;
    end;
  end;
end; {CreateLink}

{
Aufrufe:
CreateFolder(<GruppenName>);
	<Gruppenname> : Komplette Pfadangabe der Programmgruppe

CreateLink(<Dateiname>,<Shortcutname>,<Shortcuttitel>);
	<Dateiname> : Datei, auf die der Shortcut verweisen soll
	<Shortcutname> : Dateiname des Shortcuts (Endung : .lnk)
	<Shortcuttitel> : Beschreibung des Shortcuts

SpecialDirectory(<ID>);
	<ID> : Identifier fr Systemordner, mgliche Werte:
      		Autostart-Gruppe : CSIDL_Startup
      		Startmen : CSIDL_Startmenu
      		Programs-Men : CSIDL_Programs
      		Persnliche Favoriten : CSIDL_Favorites
      		Desktop : CSIDL_Desktopdirectory
      		"Send an"-Verzeichnis : CSIDL_Sendto

Beispiele :
CreateFolder(SpecialDirectory(CSIDL_Programs)+'Neu');
	->Erstellt die Programmgruppe "Neu" im Programs-Men.

CreateLink('C:\Test\Programm.exe',SpecialDirectory(CSIDL_Startup)+'Programm.lnk','Programm');
	->Erstellt einen Link it dem Titel "Programm" auf die Datei "C:\Test\Programm.exe"
	  in der Autostart-Gruppe.
}

end.
